#pragma once

#include <search/config/virthost.h>

#include <kernel/externalrelev/relev.h>

#include <library/cpp/object_factory/object_factory.h>

class ICustomCgi;
class IRemapperUrlDocId;
class TBaseCommonSearch;
class TRTYIndexData;
struct TRTYServerConfig;

struct TIndexFileEntry;
typedef TVector<TIndexFileEntry> TIndexFileEntries;

namespace NRTYServer {

    enum class EUrlIdSource {
        DDK,
        External
    };

    class IExternalSearchCreator {
    public:
        struct TParams {
            const TBaseCommonSearch& Search;
            IRemapperUrlDocId& UrlDocId;
            TRTYIndexData* IndexData;
        };

        using TFactory = NObjectFactory::TObjectFactory</*product=*/IExternalSearchCreator, /*key=*/TString>;

    public:
        virtual ~IExternalSearchCreator() {}

        virtual void CorrectSearchConfig(TSearchConfig& /*config*/) const {}

        virtual TAutoPtr<IExternalSearch> Create(const TParams& params) const = 0;
        virtual TSimpleSharedPtr<ICustomCgi> CreateMetaCgi(const TRequestParams& rp, const TRTYServerConfig& globalConfig) const;
        virtual TCgiFilterOptions CreateMetaCgiFilter() const;
        virtual TIndexFileEntries GetLockedIndexFiles() const;
        virtual TIndexFileEntries GetPrefetchedIndexFiles() const;
        virtual EUrlIdSource GetUrlIdSource() const;
    };

    class TBaseSearchCreator {
    public:
        struct TParams {
        };

        using TFactory = NObjectFactory::TObjectFactory</*product=*/TBaseSearchCreator, /*key=*/TString>;

    public:
        virtual ~TBaseSearchCreator() {}

        virtual THolder<TBaseSearch> Create(const TParams& params) const = 0;
    };
}
