#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

class IFastArchiveDoc {
public:
    typedef ui8 TIndex;

public:
    virtual ~IFastArchiveDoc() {}

    virtual TIndex GetPropertiesCount() const = 0;
    virtual TStringBuf GetPropertyName(TIndex index) const = 0;
    virtual TVector<TStringBuf> GetPropertyValues(TIndex index) const = 0;
};

class IFastArchive {
public:
    virtual ~IFastArchive() {}

    virtual const IFastArchiveDoc* GetDoc(ui32 docId) const = 0;
    virtual bool HasProperty(const TStringBuf& name) const = 0;
};
