#pragma once

#include "dssm_factors.h"

namespace NRTYFeatures {
    //
    // TDssmBundleDebug: editable version of TDssmBundle (used only for tests)
    //
    class TDssmBundleDebug: public TDssmBundle {
    public:
        void AddModel(const TString modelName, TInputTraits inputs, TVector<TString>&& queryEmbs) {
            DbgAddModel(modelName, inputs, std::move(queryEmbs));
        }
        void AddFactor(const TString& factorName, const TFactorBinding& factor) {
            DbgAddFactor(factorName, factor);
        }

    public:
        static TInputTraits QueryUrlTitle() {
            return TInputTraits{true, true, false, false};
        }
        static TInputTraits QueryHostPathTitle() {
            return TInputTraits{true, true, true, false};
        }
        static TInputTraits QueryRegHostPathTitle() {
            return TInputTraits{true, true, true, true};
        }
    };
}
