#include <search/config/virthost.h>
#include <saas/rtyserver/search/factory/factory.h>
#include <search/fresh/search.h>

namespace {

    class TFreshCreator: public NRTYServer::IExternalSearchCreator {
        TAutoPtr<IExternalSearch> Create(const NRTYServer::IExternalSearchCreator::TParams& /*params*/) const override {
            return NFresh::CreateSearch();
        }

        TIndexFileEntries GetLockedIndexFiles() const override {
            return {};
        }
    };
}

NRTYServer::IExternalSearchCreator::TFactory::TRegistrator<TFreshCreator> FreshSearch("freshsearch");
NRTYServer::IExternalSearchCreator::TFactory::TRegistrator<TFreshCreator> MemoryFresh("memoryfresh");
