#pragma once

#include <library/cpp/wordpos/wordpos.h>
#include <util/generic/vector.h>
#include <util/system/defaults.h>

class TFactorStorage;
struct TFullPosition;


class TBm25LevelsTracker {
private:
    size_t QueryWordNumber;
    TVector<ui32> WordFreq[NUM_OLD_FORM_CLASSES];

public:
    ~TBm25LevelsTracker() {};
    void Init(const size_t queryWordNumber);
    void NewDoc();
    void Add(const TFullPosition& pos, const size_t wordIdx);
    float CalcScore(const TVector<float>& wordWeight, const ui32 form, const ui32 zoneLength, const ui32 avgZoneLength);
    float CalcCmScore(const ui32 form);
    float CalcCZScore(const ui32 form);
    float CalcInvFreq(const ui32 form);
};
