#pragma once

#include "bm25levels.h"
#include <kernel/externalrelev/sent_zones.h>
#include <ysite/yandex/gators/gators.h>
#include <util/generic/noncopyable.h>
#include <util/generic/vector.h>
#include <util/system/defaults.h>
#include <search/relevance/ann_features.h>

struct TFullPositionEx;
struct TFullPosition;

class TZoneGator : public IPosGator, public TNonCopyable {
private:
    const ISentenceZonesReader* SentenceZonesReader;
    TVector<float> NormalizedWordWeight;
    ui32 DocId;
    TFactorStorage* Factors;
    TVector<TBm25LevelsTracker> Bm25Levels;

private:
    void Add(const TFullPosition& pos, const size_t wordIdx);

public:
    TZoneGator(const float* wordWeight, const ui32 wordWeightSize, const ISentenceZonesReader* sentenceZonesReader);
    void SetFactorStorage(TFactorStorage* factors);
    virtual void InitNextDoc(TNewDocParams* gatorParams) override;
    virtual void AddPositions(TFullPositionEx* pos, size_t count, ERelevanceType rt) override;
    virtual void CalcFeatures(TPosGatorCalcFeaturesParams& params) override;
};
