#pragma once

#include <saas/library/searchserver/client.h>
#include <saas/rtyserver/search/common/request.h>

class TMainSearchServer;

class TMainSearchRequest: public TSearchClient, public TMetaRequestFeatures {
private:
    // TSearchClient
    virtual ISearchReplier::TPtr DoSelectHandler(IReplyContext::TPtr context) override;
    TMainSearchServer* const Parent;
    TSearchServerMetrics* const Metrics;
    const TRTYServerConfig& Config;
public:
    TMainSearchRequest(TMainSearchServer* parent, TSearchServerMetrics* metrics, const TRTYServerConfig& config)
        : Parent(parent)
        , Metrics(metrics)
        , Config(config)
    {

    }
    // TSearchClient
    virtual TServerInfo GetServerInfo(bool isHumanReadable) const override;

    virtual void OnBeginProcess(IReplyContext::TPtr context) override;

    // TMetaRequestFeatures
    virtual TMetaSearchServerFeatures& GetFeatures() override;
};
