#pragma once

#include "request.h"

#include <saas/rtyserver/search/common/server.h>
#include <saas/library/searchserver/server.h>
#include <saas/util/events_rate_calcer.h>
#include <saas/util/queue.h>

class TMessageSearchDocIds;
class TSearchEnginesManager;

class TMainSearchServer
    : public TSearchServerBase
    , public TMetaSearchServerFeatures
{
private:
    ui32 ProcessPageQuery(TString query, int page, TMessageSearchDocIds* message);
    void ProcessSearchDocIds(TMessageSearchDocIds* message);

public:
    TMainSearchServer(TSearchEnginesManager& sem, const NRTYServer::TSearcherConfig& config, const TDefaultKeyPrefix* defaultKeyPrefix = nullptr);
    virtual ~TMainSearchServer();

    // IMessageProcessor
    bool Process(IMessage* message) override;
    TString Name() const override;

private:
    TEventRate<> HttpSearchRateMeter;
    // TSearchServerBase
    TClientRequest* CreateClient() override final;
    void OnFailRequest(int failstate) override;
};
