#pragma once

#include <saas/library/searchserver/replier.h>
#include <saas/rtyserver/search/common/replier.h>

class TSearchEnginesManager;

namespace NMemorySearch {
    class TResponseTimeGuard;
}

class TRTYCommonSearchReplier
    : public TCommonSearchReplier
    , public NRTYServer::TCommonReplierFeatures
{
private:
    const TSearchEnginesManager& SEM;
    bool ManualPruning = false;
    bool DisablePruning = false;
    ui64 DefaultKps;
    ERequestType CommonRequestType;

protected:
    virtual TDuration GetDefaultTimeout() const override;

    virtual void OnRequestExpired(const int httpCode) override;
    virtual void OnQueueFailure() override;
    virtual bool ProcessFetch() override;
    virtual bool ProcessRequest() override;
    virtual const TSearchHandlers* GetSearchHandlers() const override;

protected:
    THolder<NMemorySearch::TResponseTimeGuard> CreateTimeGuard() const;

    void AdjustRTYRequest();
    void ScanPruningOptions();
    bool NeedPruningAdjust();

public:
    TRTYCommonSearchReplier(IReplyContext::TPtr context, const TCommonSearch* commonSearcher, const TSearchEnginesManager& sem, ui64 defaultKps);
};
