#pragma once

#include <search/meta/metasearch.h>

struct TRTYServerConfig;

namespace NRTYServer {

class IExternalSearchCreator;

class TMetaSearch : public ::TMetaSearch {
public:
    TMetaSearch(const TRTYServerConfig& globalConfig);
    ~TMetaSearch();

    const TRTYServerConfig& GetGlobalConfig() const {
        return GlobalConfig;
    }

    using ::TMetaSearch::SearchOpen;
    int SearchOpen(TAutoPtr<TSearchConfig> config);

private:
    ISearchContext* CreateContext() const override;
    ISearchContext* CreateContext(const TSearchRequestData&) const override;

private:
    const TRTYServerConfig& GlobalConfig;
    const TAtomicSharedPtr<IExternalSearchCreator> ExternalSearchCreator;
};

} // namespace NRTYServer
