#pragma once

#include <saas/library/daemon_base/metrics/metrics.h>

struct TSearchServerMetrics : public TCompositeMetric {
    TPart<TQueriesMetrics> ResponseTime;
    TPart<TQueriesMetrics> SnippetsFetchTime;
    TPart<TQueriesMetrics> FactorRequestTime;
    TPart<TOrangeMetric> QueueSize;
    TPart<TOrangeMetric> FailQueueSize;
    TPart<TOrangeMetric> DroppedRequests;
    TPart<TOrangeMetric> TimeoutDrops;

    TSearchServerMetrics(const TString& serverType)
        : ResponseTime(this, GetMetricsPrefix() + serverType + "_ResponseTime")
        , SnippetsFetchTime(this, GetMetricsPrefix() + serverType + "_SnippetsFetchTime")
        , FactorRequestTime(this, GetMetricsPrefix() + serverType + "_FactorRequestTime")
        , QueueSize(this, GetMetricsPrefix() + serverType + "_RequestQueueSize")
        , FailQueueSize(this, GetMetricsPrefix() + serverType + "_FailQueueSize")
        , DroppedRequests(this, GetMetricsPrefix() + serverType + "_DroppedRequests")
        , TimeoutDrops(this, GetMetricsPrefix() + serverType + "_TimeoutDrops")
    {
    }
};

class TIndexMetrics : public TCompositeMetric {
public:
    TPart<TOrangeMetric> DiskDocCount;
    TPart<TOrangeMetric> DiskDeletedDocCount;
    TPart<TOrangeMetric> MemoryDocCount;
    TPart<TOrangeMetric> SearchableDiskIndexNumber;
    TPart<TOrangeMetric> IdleDiskIndexNumber;

    TIndexMetrics()
        : DiskDocCount(this, GetMetricsPrefix() + "IndexStats_DiskDocsTotal")
        , DiskDeletedDocCount(this, GetMetricsPrefix() + "IndexStats_DiskDocsDeleted")
        , MemoryDocCount(this, GetMetricsPrefix() + "IndexStats_MemoryDocsTotal")
        , SearchableDiskIndexNumber(this, GetMetricsPrefix() + "DiskIndex_Number_Searchable")
        , IdleDiskIndexNumber(this, GetMetricsPrefix() + "DiskIndex_Number_Idle")
    {
    }
};
