#pragma once

#include <saas/rtyserver/search/search_engines_manager.h>

#include <search/daemons/httpsearch/neh/request.h>
#include <saas/library/searchserver/replier.h>
#include <saas/library/searchserver/neh.h>
#include <saas/rtyserver/search/common/request.h>
#include <search/request/data/reqdata.h>

class TMetaSearchServerFeatures;

class TMetaSearchNehRequest: public TYsNehClientRequest, public TMetaRequestFeatures, public TNehReplyContext {
private:
    TMetaSearchServerFeatures& Features;
    TInstant RequestCreatedTime;
    TBlob Buf;
public:
    TMetaSearchNehRequest(YandexHttpServer* server, TMetaSearchServerFeatures& features, const NNeh::IRequestRef& req);

    // TYsNehClientRequest
    void ScanQuery() override {} // move scaning query to constructor
    void Process(void*) override;
    bool CreateSearcher(const char* name) override;

    NNeh::IRequest& GetRequest() override {
        return *Request_;
    }

    NNeh::TRequestOut& GetReplyOutput() override {
        return Reply_;
    }
    // TMetaRequestFeatures
    TMetaSearchServerFeatures& GetFeatures() override {
        return Features;
    }

    TInstant GetRequestStartTime() const override {
        return RequestCreatedTime;
    }

    NSearch::IOutputContext& Output() override {
        return ReplyContext_;
    }

    const TSearchRequestData& GetRequestData() const override {
        return RD_;
    }

    TSearchRequestData& MutableRequestData() override {
        return RequestData();
    }

    TBlob& GetBuf() override {
        return Buf;
    }
};
