#pragma once

#include "request.h"

#include <saas/library/searchserver/neh.h>
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/search/common/server.h>
#include <saas/util/queue.h>

class TSearchEnginesManager;

class TBaseSearchServer
    : public IMessageProcessor
    , public TSearchNehServer
{
private:
    TSearchEnginesManager& SearchEngineManager;
public:
    TBaseSearchServer(TSearchEnginesManager& sem, const THttpServerOptions& config);
    ~TBaseSearchServer();

    // IMessageProcessor
    bool Process(IMessage* message) override;
    TString Name() const override;

private:
    virtual TAutoPtr<IObjectInQueue> DoCreateClientRequest(ui64 id, NNeh::IRequestRef req) final override;
};

class TMetaSearchNehServer
    : public TSearchNehServer
    , public TMetaSearchServerFeatures
{
public:
    TMetaSearchNehServer(TSearchEnginesManager& sem, const NRTYServer::TSearcherConfig& config, const THttpServerOptions& serverConfig, const TDefaultKeyPrefix* defaultKeyPrefix = nullptr);
    ~TMetaSearchNehServer();

    // IMessageProcessor
    bool Process(IMessage* message) override;
    TString Name() const override;

private:
    virtual TAutoPtr<IObjectInQueue> DoCreateClientRequest(ui64 id, NNeh::IRequestRef req) final override;
};
