#pragma once

#include <util/folder/path.h>
#include <util/generic/ptr.h>

class TCommonSearch;

namespace NRTYServer {
    class TPrefetcher {
    private:
        class TImpl;
    private:
        THolder<TImpl> Impl;
    public:
        TPrefetcher(const TFsPath& plainQueriesFile);
        virtual ~TPrefetcher();

        bool IsEnabled() const;
        void Prefetch(const TCommonSearch* search);
    };

    void PrefetchCommon(const TCommonSearch* search);
    void PrefetchCommon(TPrefetcher* prefetcher, const TCommonSearch* search);
}
