#include "aggregators.h"

THolder<ILowAggregator> MakeLowAggregator(const ERtyAggregationType aggrType, const TCateg& firstResult) {
    switch(aggrType) {
        case ERtyAggregationType::AGGR_MIN:
            return MakeHolder<TMinAggregator>(firstResult);
        case ERtyAggregationType::AGGR_MAX:
            return MakeHolder<TMaxAggregator>(firstResult);
        case ERtyAggregationType::AGGR_UNIQUE:
            return MakeHolder<TUniqueAggregator>(firstResult);
        case ERtyAggregationType::AGGR_SUM:
            return MakeHolder<TSumAggregator>(firstResult);
    }
}
