#pragma once

#include <saas/rtyserver/search/processors/processor.h>

#include <util/generic/hash.h>

class TGroupAttrFacetBuilder: public TRTYFacetBase {
public:
    TGroupAttrFacetBuilder(const TVector<TString>& attributes, const ui32 docCount);

    virtual void ProcessDoc(ui32 docId, const NGroupingAttrs::TDocsAttrs& da) override;
    virtual void FillProperties(TSearcherProps* props) const override;

private:
    static const ui32 DefaultTop = 1 << 31;

    typedef TCateg TAttrValue;

    struct TFacetField {
        TString StringValue;
        ui32 Count = 0;
    };

    struct TFacet: THashMap<TAttrValue, TFacetField> {
        ui32 Top = DefaultTop;
    };

    using TFacets = THashMap<TString, TFacet>;

private:
    TVector<TString> Attributes;
    const ui32 DocCountInSegment;

    ui32 MaxDocId = 0;
    TFacets Facets;
};
