#pragma once

#include <saas/rtyserver/search/processors/processor.h>
#include <library/cpp/logger/global/global.h>
#include <kernel/groupattrs/docsattrs.h>

class TDocidsFilter : public IRTYDocProcessor {
public:
    typedef THashSet<ui32> TDocIds;

    void FillProperties(TSearcherProps* /*props*/) const override {
    }

    TDocidsFilter(const TDocIds& docIds)
        : DocIds(docIds)
    {
    }

    void Process(ui32 /*docId*/, const NGroupingAttrs::TDocsAttrs& /*da*/, const TAllDocPositions& /*doc*/, const TTRIteratorHitInfos* /*hitInfos*/) override {
    }

protected:
    TDocIds DocIds;
};

class TAccessedDocidsFilter : public TDocidsFilter {
public:
    TAccessedDocidsFilter(const TDocIds& docIds)
        : TDocidsFilter(docIds)
    {}

    virtual bool DocumentBanned(ui32 docId) const {
        return !DocIds.contains(docId);
    }
};

class TBanedDocidsFilter : public TDocidsFilter {
public:
    TBanedDocidsFilter(const TDocIds& docIds)
        : TDocidsFilter(docIds)
    {}

    virtual bool DocumentBanned(ui32 docId) const {
        return DocIds.contains(docId);
    }
};
