#pragma once

#include <saas/rtyserver/search/processors/processor.h>

#include <contrib/libs/re2/re2/re2.h>

class TRegExpDocidsFilter: public IRTYDocProcessor {
public:
    TRegExpDocidsFilter(const IArchiveData& archiveData);

    virtual void FillProperties(TSearcherProps* /*props*/) const override {}

    virtual bool DocumentBanned(ui32 docId) const override;

    virtual void Process(ui32 /*docId*/, const NGroupingAttrs::TDocsAttrs& /*da*/, const TAllDocPositions& /*doc*/, const TTRIteratorHitInfos* /*hitInfos*/) override {}

    void AddFilter(const TString& regExp, const TString& propName, bool inverseMatching = false, bool ignoreCase = false);
    /**
    если inverseMatching - false, то докумены которые не матчатся регуляркой будут баниться
    иначе - банятся те, которые матчатся
    */
    bool Empty() const;

private:
    struct TRegexpConfigs {
        RE2 RegExp;
        TString PropName;
        bool InverseMatching;

    public:
        TRegexpConfigs(const TString& regexp, const TString& propName, bool inverseMatching = false, bool ignoreCase = false);
        bool Check(const TString& text) const;
        static RE2::Options RE2OptionsWithIgnoreCase(bool ignoreCase);
    };

private:
    const IArchiveData& ArchiveData;
    TVector<TAtomicSharedPtr<TRegexpConfigs>> Regexps; // потому что у RE2 нет конструктора копирования и поэтому нельзя просто поместить в вектор
};
