#pragma once
#include <kernel/externalrelev/relev.h>
#include <search/session/reqenv.h>
#include <ysite/yandex/srchmngr/arcdata.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/search/processors/abstract/abstract.h>

class IFastArchive;
class TRTYDocProcessor: public TDocProcessors {
    TVector<TString> FacetsNames;
    TVector<TString> FastFacetsNames;
    TVector<TString> SumsNames;
    TVector<TString> BordersNames;
    TVector<TString> GroupAttrFacetsNames;
    TVector<TString> ExtendedFacetExpressions;
public:
    static IRTYDocProcessor* Create(const TRequestParams& rp, const IRemapperUrlDocId& remapper, const IArchiveData& AD, const IFastArchive* FA, const TCgiParameters& cgiParams) {
        TAutoPtr<TRTYDocProcessor> result = new TRTYDocProcessor(rp, remapper, AD, FA, cgiParams);
        if (!result->Empty())
            return result.Release();
        else
            return nullptr;
    }

    TRTYDocProcessor(const TRequestParams& rp, const IRemapperUrlDocId& remapper, const IArchiveData& AD, const IFastArchive* FA, const TCgiParameters& cgiParams);
};

