#include "searchers.h"

#include <search/request/data/reqdata.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/indexer_core/index_component_storage.h>

TRTYSearcher::TRTYSearcher(const TSearchRequestData& rd, const TRTYServerConfig& config)
    : IRTYSearcher(rd, config)
{}

void TRTYSearcher::Search(ICustomReportBuilder& builder) const {
    TRTYSearchRequestContext searchContext(RD.CgiParam, *RD.RP, Config);
    CHECK_WITH_LOG(Controllers.size());

    TString componentForSearch = searchContext.GetComponentName();
    if (!TIndexComponentsStorage::Instance().CheckComponent(componentForSearch)) {
        builder.AddErrorMessage("Can't initialize search context: " + TIndexComponentsStorage::Instance().GetComponentsDescription());
        return;
    }
    TIndexComponentsStorage::Instance().GetComponent(componentForSearch)->SearchCustom(Controllers, builder, searchContext);
}

void TRTYSearcher::RegisterControllers(const TVector<IIndexController::TPtr>& controllers) {
    Controllers = controllers;
}

TRTYSearcher::TRegistrator TRTYSearcher::Registrator("default");
