#pragma once

#include "search_source.h"

#include <library/cpp/object_factory/object_factory.h>
#include <saas/rtyserver/search/context/rty_search_context.h>

class IRTYSearcher {
public:
    IRTYSearcher(const TSearchRequestData& rd, const TRTYServerConfig& config)
        : RD(rd)
        , Config(config)
    {}

    virtual void Search(ICustomReportBuilder& builder) const = 0;
    virtual ~IRTYSearcher() {}
    virtual void RegisterControllers(const TVector<IIndexController::TPtr>& controllers) = 0;

    using TFactory = NObjectFactory::TParametrizedObjectFactory<IRTYSearcher, TString,
                                                                const TSearchRequestData&,
                                                                const TRTYServerConfig&>;
    using TPtr = TAtomicSharedPtr<IRTYSearcher>;

protected:
    const TSearchRequestData& RD;
    const TRTYServerConfig& Config;
};

class TRTYSearcher : public IRTYSearcher {
public:
    TRTYSearcher(const TSearchRequestData& rd, const TRTYServerConfig& config);

    void RegisterControllers(const TVector<IIndexController::TPtr>& controllers) override;
    virtual void Search(ICustomReportBuilder& builder) const override;

private:
    TVector<IIndexController::TPtr> Controllers;
    using TRegistrator = IRTYSearcher::TFactory::TRegistrator<TRTYSearcher>;
    static TRegistrator Registrator;
};
