#pragma once

#include <saas/library/daemon_base/actions_engine/async_task_executor.h>

#include <util/generic/strbuf.h>

class TCgiParameters;

class TMessageCollectServerInfo;
namespace NRTYServer {
    class TSynchronizer;

    class ISynchronizerProcessor {
    public:
        ISynchronizerProcessor(TSynchronizer* synchronizer);
        typedef TAtomicSharedPtr<ISynchronizerProcessor> TPtr;
        virtual ~ISynchronizerProcessor() {};

        virtual bool ProcessRequest(const TCgiParameters& cgi, TStringBuf postBuffer, TAsyncTaskExecutor::TTask& task) = 0;
        virtual TString GetProcessorName() = 0;
        virtual void Start() {};
        virtual void Stop() {};
        virtual bool CollectServerInfo(TMessageCollectServerInfo*) {
            return false;
        }

    protected:
        TSynchronizer* Synchronizer;
    };
}
