#include "config.h"

namespace NRTYServer {
    bool TSynchronizerConfig::DoCheck() const {
        VERIFY_WITH_LOG(!DetachPath.empty(), "Synchronized.DetachPath must be specified. Do not reuse other dirs.");
        return true;
    }

    void TSynchronizerConfig::DoInit(const TYandexConfig::Section& componentSection) {
        const TYandexConfig::Directives& dir = componentSection.GetDirectives();

        if (!dir.GetValue("ThreadsSync", ThreadsSync))
            ThreadsSync = 16;
        if (!dir.GetValue("ThreadsDetach", ThreadsSync))
            ThreadsDetach = 16;
        if (!dir.GetValue("DetachPath", DetachPath))
            DetachPath = "";
        if (!dir.GetValue("ClearPreviousResults", DetachClearPreviousResults))
            DetachClearPreviousResults = false;
        if (!dir.GetValue("DetachedSegmentSize", DetachedSegmentSize))
            DetachedSegmentSize = 10000000;
        if (!dir.GetValue("SlotInfoFile", SlotInfoFile))
            SlotInfoFile = "description";
        if (!dir.GetValue("PersistentSearchBanFile", PersistentSearchBanFile))
            PersistentSearchBanFile = "persistent_search_ban";
        if (!dir.GetValue("PersistentSearchBanOnEmptyIndex", PersistentSearchBanOnEmptyIndex))
            PersistentSearchBanOnEmptyIndex = false;
        if (!dir.GetValue("EnableSearchOnStart", EnableSearchOnStart))
            EnableSearchOnStart = false;
        if (!dir.GetValue("DetachedSegmentSizeDeviation", DetachedSegmentSizeDeviation))
            DetachedSegmentSizeDeviation = 0.15f;

        const TYandexConfig::TSectionsMap children = componentSection.GetAllChildren();
        const auto iter = children.find(TResourceFetchConfig::SECTION_NAME);
        if (iter != children.end() && iter->second) {
            ResourceFetchConfig.Reset(new TResourceFetchConfig());
            ResourceFetchConfig->Init(*iter->second);
        }
    }

    void TSynchronizerConfig::DoToString(IOutputStream& so) const {
        so << "ThreadsSync : " << ThreadsSync << Endl;
        so << "ThreadsDetach : " << ThreadsDetach << Endl;
        so << "DetachPath : " << DetachPath << Endl;
        so << "DetachedSegmentSize : " << DetachedSegmentSize << Endl;
        so << "DetachedSegmentSizeDeviation : " << DetachedSegmentSizeDeviation << Endl;
        so << "SlotInfoFile : " << SlotInfoFile << Endl;
        so << "PersistentSearchBanFile : " << PersistentSearchBanFile << Endl;
        so << "PersistentSearchBanOnEmptyIndex : " << PersistentSearchBanOnEmptyIndex << Endl;
        so << "EnableSearchOnStart : " << EnableSearchOnStart << Endl;
        so << "ClearPreviousResults : " << DetachClearPreviousResults << Endl;
        if (ResourceFetchConfig) {
            ResourceFetchConfig->ToString(so);
        }
    }

    IDaemonModuleConfig::TFactory::TRegistrator<TSynchronizerConfig> TSynchronizerConfig::Registrator(SYNCHRONIZER_MODULE_NAME);
}
