#pragma once

#include "synchronizer.h"
#include <saas/rtyserver/synchronizer/library/config/config.h>
#include <saas/library/daemon_base/module/module.h>

namespace NRTYServer {

    class TSynchronizerConfig: public TPluginConfig<IDaemonModuleConfig> {
    public:
        ui32 ThreadsSync;
        ui32 ThreadsDetach;
        ui32 DetachedSegmentSize;
        float DetachedSegmentSizeDeviation;
        TString DetachPath;
        bool DetachClearPreviousResults;
        TString SlotInfoFile;
        TString PersistentSearchBanFile;
        bool PersistentSearchBanOnEmptyIndex;
        bool EnableSearchOnStart;
        THolder<TResourceFetchConfig> ResourceFetchConfig;
        static IDaemonModuleConfig::TFactory::TRegistrator<TSynchronizerConfig> Registrator;
    protected:
        virtual bool DoCheck() const override;
        virtual void DoInit(const TYandexConfig::Section& componentSection) override;
        virtual void DoToString(IOutputStream& so) const override;
    public:

    };

}
