#pragma once

#include "abstract_processor.h"
#include <saas/rtyserver/merger/detach_task.h>

namespace NRTYServer {

    class TDetachProcessor : public ISynchronizerProcessor {
    public:
        TDetachProcessor(TSynchronizer* synchronizer);
        bool ProcessRequest(const TCgiParameters& cgi, TStringBuf postBuffer, TAsyncTaskExecutor::TTask& task);
        virtual TString GetProcessorName() {
            return "detach";
        }
        virtual void Stop();
    private:
        void ProcessTask(const TDetachTask::TContext& context, TAsyncTaskExecutor::TTask& task);
    private:
        std::atomic<bool> RigidStop;
        TMutex Mutex;
    };
}
