#include "config.h"

static const TString SKY_GET_SECTION_NAME = "SkyGet";
static const TString YT_FETCH_SECTION_NAME = "YTFetch";
const TString NRTYServer::TResourceFetchConfig::SECTION_NAME = "ResourceFetchConfig";

void NRTYServer::TResourceFetchConfig::TSkyGetConfig::Init(const TYandexConfig::Section& componentSection) {
    const TYandexConfig::Directives& dir = componentSection.GetDirectives();

    if (!dir.GetValue("DownloadSpeedBps", DownloadSpeedBps))
        DownloadSpeedBps = 0;
    if (!dir.GetValue("UploadSpeedBps", UploadSpeedBps))
        UploadSpeedBps = 0;
    if (!dir.GetValue("TimeoutSeconds", TimeoutSeconds))
        TimeoutSeconds = DEFAULT_TIMEOUT_SEC;
}

void NRTYServer::TResourceFetchConfig::TSkyGetConfig::ToString(IOutputStream& so) const {
    so << "<" + SKY_GET_SECTION_NAME + ">" << Endl;
    so << "DownloadSpeedBps : " << DownloadSpeedBps << Endl;
    so << "UploadSpeedBps : " << UploadSpeedBps << Endl;
    so << "TimeoutSeconds : " << TimeoutSeconds << Endl;
    so << "</" + SKY_GET_SECTION_NAME + ">" << Endl;

}

void NRTYServer::TResourceFetchConfig::TYTFetchConfig::Init(const TYandexConfig::Section& componentSection) {
    const TYandexConfig::Directives& dir = componentSection.GetDirectives();
    dir.GetValue("PathToLock", PathToLock);
    MinutesOfWaitingForLock = TDuration::Minutes(dir.Value<ui64>("MinutesOfWaitingForLock", MinutesOfWaitingForLock.Minutes()));
    dir.GetValue("LockMaxAttempts", LockMaxAttempts);
    if (!dir.GetValue("Proxy", Proxy)) {
        Proxy = TString();
    }
    if (!dir.GetValue("Token", Token)) {
        Token = TString();
    }
    dir.GetValue("YTHosts", YTHosts);
    dir.GetValue("WriteBytesPerSec", WriteBytesPerSec);
}

void NRTYServer::TResourceFetchConfig::TYTFetchConfig::ToString(IOutputStream& so) const {
    so << "<" + YT_FETCH_SECTION_NAME + ">" << Endl;
    so << "PathToLock : " << PathToLock << Endl;
    so << "MinutesOfWaitingForLock : " << MinutesOfWaitingForLock.Minutes()  << Endl;
    so << "LockMaxAttempts : " << LockMaxAttempts << Endl;
    so << "Proxy : " << Proxy << Endl;
    so << "Token : " << Token << Endl;
    so << "YTHosts: " << YTHosts << Endl;
    so << "WriteBytesPerSec: " << WriteBytesPerSec << Endl;
    so << "</" + YT_FETCH_SECTION_NAME + ">" << Endl;

}

void NRTYServer::TResourceFetchConfig::Init(const TYandexConfig::Section& componentSection) {
    const TYandexConfig::TSectionsMap children = componentSection.GetAllChildren();

    const auto iterSkyGet = children.find(SKY_GET_SECTION_NAME);
    if (iterSkyGet != children.end() && iterSkyGet->second) {
        SkyGetConfig.ConstructInPlace();
        SkyGetConfig->Init(*iterSkyGet->second);
    }

    const auto iterYTFetch = children.find(YT_FETCH_SECTION_NAME);
    if (iterYTFetch != children.end() && iterYTFetch->second) {
        YTFetchConfig.ConstructInPlace();
        YTFetchConfig->Init(*iterYTFetch->second);
    }

    const TYandexConfig::Directives& dir = componentSection.GetDirectives();
    dir.GetValue("ApplyEmptyIndex", ApplyEmptyIndex);
}

void NRTYServer::TResourceFetchConfig::ToString(IOutputStream& so) const {
    so << "<" + SECTION_NAME + ">" << Endl;
    so << ApplyEmptyIndex << Endl;
    if (SkyGetConfig) {
        SkyGetConfig->ToString(so);
    }
    if (YTFetchConfig) {
        YTFetchConfig->ToString(so);
    }
    so << "</" + SECTION_NAME + ">" << Endl;
}
