#pragma once

#include <library/cpp/yconf/conf.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>

namespace NRTYServer {

    class TResourceFetchConfig {
    public:
        class TSkyGetConfig {
        public:
            static const ui32 DEFAULT_TIMEOUT_SEC = 300;
            //0 - no limit
            ui64 DownloadSpeedBps = 0;
            ui64 UploadSpeedBps = 0;
            ui32 TimeoutSeconds = DEFAULT_TIMEOUT_SEC;

            void Init(const TYandexConfig::Section& componentSection);
            void ToString(IOutputStream& so) const;

        };

        class TYTFetchConfig {
        public:
            TString PathToLock;
            TDuration MinutesOfWaitingForLock  = TDuration::Minutes(15);
            ui32 LockMaxAttempts = 10;
            TString Proxy;
            TString Token;
            TString YTHosts = TString();
            ui32 WriteBytesPerSec = 30 * 1024 * 1024;

            void Init(const TYandexConfig::Section& componentSection);
            void ToString(IOutputStream& so) const;
        };

    public:
        static const TString SECTION_NAME;
        TMaybe<TSkyGetConfig> SkyGetConfig;
        TMaybe<TYTFetchConfig> YTFetchConfig;
        bool ApplyEmptyIndex {false};

        void Init(const TYandexConfig::Section& componentSection);
        void ToString(IOutputStream& so) const;
    };
}
