#pragma once

#include <saas/rtyserver/synchronizer/library/config/config.h>

#include <saas/protos/shards.pb.h>

#include <robot/library/skynet/skynet.h>

#include <util/datetime/base.h>
#include <util/folder/path.h>

namespace NRTYServer {

    class IRemoteResourceGetCallback : public NOxygen::ISkyGetCallback {
    public:

        virtual void OnSkyGetStart(ui32 retryNum) = 0;
        virtual void OnSkyGetError(const TString& errorInfo) = 0;

        virtual ~IRemoteResourceGetCallback() {
        }
    };

    class TRemoteResource {
    public:
        TRemoteResource() = default;
        TRemoteResource(const TString& description);
        TRemoteResource(const NRTYServer::TShardResource& shard)
            : Name(shard.GetName())
            , Timestamp(TInstant::Seconds(shard.GetTimestamp()))
            , Torrent(shard.GetTorrent())
            , Rsync(shard.GetRsync())
            , YTIndexTable(shard.GetYTIndexTable())
        {
        }

        void SetName(const TString &name) {
            Name = name;
        }
        void SetTimestamp(const TInstant &timestamp) {
            Timestamp = timestamp;
        }
        void SetTorrent(const TString &torrent) {
            Torrent = torrent;
        }
        void SetRsync(const TString &rsync) {
            Rsync = rsync;
        }
        void SetYTIndexTable(const TString &ytPath) {
            YTIndexTable = ytPath;
        }
        void SetLocalPath(const TString &localPath) {
            LocalPath = localPath;
        }
        TString GetName() const {
            return Name;
        }

        bool Fetch(const TFsPath& destination,
            const TResourceFetchConfig& = TResourceFetchConfig(),
            IRemoteResourceGetCallback* callback = nullptr) const;

    private:
        bool FetchFromTorrent(const TFsPath& destination, const NOxygen::TSkyGetConfig& config,
            IRemoteResourceGetCallback* callback, bool cleanOnError = true) const;
        bool FetchFromRsync(const TFsPath& destination) const;
        bool FetchFromYTIndexTable(const TFsPath& destination,
            const NRTYServer::TResourceFetchConfig::TYTFetchConfig& config) const;
        bool FetchFromLocalPath(const TFsPath& destination) const;

    private:
        TString Name;
        TInstant Timestamp;
        TString Torrent;
        TString Rsync;
        TString YTIndexTable;
        TString LocalPath;
    };
}
