#pragma once

#include <saas/rtyserver/synchronizer/library/config/config.h>
#include <saas/rtyserver/synchronizer/library/resource.h>
#include <saas/rtyserver/synchronizer/library/constants/consume_mode.h>

#include <functional>

class TFsPath;
class IIndexWithComponents;

namespace NRTYServer {
    class TRemoteResource;

    bool FetchResource(const TRemoteResource& resource, const TFsPath& destination);
    bool FetchAndConsumeIndices(const TRemoteResource& resource, EConsumeMode mode,
        const TFsPath& temp, const NRTYServer::TResourceFetchConfig& config = NRTYServer::TResourceFetchConfig(),
        NRTYServer::IRemoteResourceGetCallback* callback = nullptr,
        std::function<bool(IIndexWithComponents&)> indexProcessorCb = nullptr);

    void ClearFinalIndexes();
}
