#pragma once

#include "abstract_processor.h"

#include <util/folder/path.h>
#include <util/generic/strbuf.h>
#include <util/system/mutex.h>

namespace NRTYServer {

    class TSlotInfoProcessor : public ISynchronizerProcessor {
    public:
        TSlotInfoProcessor(TSynchronizer* synchronizer);
        bool ProcessRequest(const TCgiParameters& cgi, TStringBuf postBuffer, TAsyncTaskExecutor::TTask& task) override;
        TString GetProcessorName() override {
            return "slot_info";
        }
        void Start() override;
        bool CollectServerInfo(TMessageCollectServerInfo*) override;

    private:
        void Set(TStringBuf contents);
        void CreatePersistentSearchBan();
        void RemovePersistentSearchBan();
        bool CheckPersistentSearchBan();
        void CheckEmptyIndex();
        void Update();

    private:
        const TFsPath SlotInfoFile;
        const TFsPath PersistentSearchBanFile;
        // FIXME(salmin) replace flags with RAII objects
        bool SearchDisabledBySlotInfo;
        bool SearchDisabledByPersistentBan;
        TMutex SlotInfoMutex;
    };
}
