#include "signals.h"

#include <saas/library/daemon_base/unistat_signals/signals_ut_helpers.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/iterator/zip.h>

const TVector<TString> defaultRealmNames = {"Persistent", "Realtime"};
const TVector<ui32> defaultRealmTimestamps = {102, 82};

Y_UNIT_TEST_SUITE(RtyServerUnistatSignalsSuite) {
    Y_UNIT_TEST(TestInit) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordSearchSuccess) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        NRTYServer::TUnistatRecordContext ctx(RT_Search, 100, 200, true);
        ctx.TotalDocsCount = 1;
        TSaasRTYServerSignals::DoUnistatRecordSearch(ctx);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordSearchFailure) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        NRTYServer::TUnistatRecordContext ctx(RT_Search, 150, 250, false);
        ctx.FailOnZero = true;
        TSaasRTYServerSignals::DoUnistatRecordSearch(ctx);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordIndexSuccess) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatRecordIndex(200, 100);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordIndexFailure) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatRecordIndex(500, 150);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordDocDssm) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatRecordDocDssm(false);
        TSaasRTYServerSignals::DoUnistatRecordDocDssm(true);
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordUserFactor) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatUserFactorCalcDefault();
        TSaasRTYServerSignals::DoUnistatUserFactorCalcError();
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordErrorSearch) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatErrorSearch();
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordUnavailable) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatUnavailable();
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordTimeouted) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatTimeouted();
        PrintSignals();
    }
    Y_UNIT_TEST(TestRecordIncomplete) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        NRTYServer::TUnistatRecordContext ctx(RT_Search, 100, 200, true);
        ctx.TotalDocsCount = 1;
        ctx.AnswerIsComplete = false;
        TSaasRTYServerSignals::DoUnistatRecordSearch(ctx);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateIndexState) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateIndexState(101);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateIndexTimestamp) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateSearchDisabledStatus(false);
        ui32 maxTimestamp = 0;
        for (const auto& [name, timestamp]: Zip(defaultRealmNames, defaultRealmTimestamps)) {
            maxTimestamp = Max(maxTimestamp, timestamp);
            TSaasRTYServerSignals::UpdateIndexTimestamp(name, timestamp);
        }
        TSaasRTYServerSignals::UpdateIndexTimestamp("", maxTimestamp);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateAverageDocSize) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateAverageDocSize(103);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateOldDocCount) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateOldDocCount(104);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateSurplusDocCount) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateSurplusDocCount(105, TInstant::Zero());
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateIndexDiskDocuments) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateIndexDiskDocuments(106);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateIndexSearchableDocuments) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateIndexSearchableDocuments(107);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUpdateSearchDisabledStatus) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::UpdateSearchDisabledStatus(false);
        PrintSignals();
    }
    Y_UNIT_TEST(TestNoBertEmbedding) {
        ClearSignals();
        TSaasRTYServerSignals::BuildSignals(defaultRealmNames);
        TSaasRTYServerSignals::DoUnistatNoBertEmbedding();
        PrintSignals();
    }
}
