#pragma once

#include <saas/rtyserver_jupi/library/extbuilder/module.h>
#include <robot/jupiter/library/rtdoc/protos/builder_task.pb.h>

namespace NFusion {
    class TExtBuilderDebugHelper : public IExtBuilderTrace {
    public:
        class TImpl;

    public:
        TExtBuilderDebugHelper();
        ~TExtBuilderDebugHelper();

        virtual void OnAppStart(const TString& statePrefix, const TAssertPolicy& assertPol) override;
        virtual ITaskTrace::TPtr OnTaskStart(const NRtDoc::TBuilderTask& task) noexcept override;
        virtual void OnTaskEnd(const NRtDoc::TBuilderTask& task, const NRtDoc::TBuilderTaskResult& result) noexcept override;

    private:
        THolder<TImpl> Impl;
    };

    class TExtBuilderComponentLogger final: public ITaskTrace {
    private:
        TString ShortDiagName;
        THolder<TLog> ComponentLog;

    public:
        TExtBuilderComponentLogger(TString shortDiagName);

        virtual TLog* GetProgressLogger() override;
    };
}
