#pragma once

#include "dbg_helper.h"

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/model/external_builder.h>

#include <library/cpp/mediator/messenger.h>

#include <util/thread/factory.h>

namespace NFusion {
    class TExtBuilderConfig;
    //
    // Application object - "Server-side" part of the supposed GRPC construction
    // Mostly cares about prefetch, etc.
    //
    class TExtBuilderApp: public TThrRefBase {
    public:
        using TPtr = TIntrusivePtr<TExtBuilderApp>;

        class TImpl;

    public:
        TExtBuilderApp(const TExtBuilderConfig& serverConfig, IExtBuilderTrace::TPtr helper);
        ~TExtBuilderApp();

        virtual void Start();
        virtual void Stop();

    private:
        THolder<TImpl> Impl;
        const TExtBuilderConfig& ExtConfig;
        IExtBuilderTrace::TPtr DiagHelper;
    };

}
