#pragma once

#include "dbg_helper.h"
#include "extbuilder_app.h"

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/model/external_builder.h>
#include <library/cpp/mediator/messenger.h>

#include <util/thread/factory.h>

namespace NFusion {
    class TExtBuilderConfig;
    const TString ExtBuilderModuleName = "EXTBUILDER";

    class TExtBuilderModule: public IDaemonModule, public NMessenger::IMessageProcessor {
    public:
        TExtBuilderModule(const IServerConfig& serverConfig);
        ~TExtBuilderModule();

        virtual bool Start(const TStartContext& /*context*/) override;
        virtual bool Stop(const TStopContext& context) override;

        static bool IsUsedStatic(const IServerConfig& serverConfig) {
            return serverConfig.GetModulesSet().contains(NameStatic());
        }

        static TString NameStatic() {
            return ExtBuilderModuleName;
        }

        virtual TString Name() const override {
            return TExtBuilderModule::NameStatic();
        }

        virtual bool Process(NMessenger::IMessage* message) override;

    private:
        const TExtBuilderConfig& ExtConfig;
        IExtBuilderTrace::TPtr DiagHelper;
        TExtBuilderApp::TPtr AppObject;
    };

}
