#pragma once

namespace NFusion {
    //
    // Various application-level verification options
    // Sets whether the process should be terminated on a error.
    //
    struct TAssertPolicy {
    public:
        bool CrashOnMergeFail_ = false;
        bool StopOnIncompleteMerge_ = false;
        bool StopAfterIncompleteMerge_ = false; // postmortem
        bool VerifyBundleDependencies_ = true;

    public:
        inline bool MustHaveAa() const {
            return VerifyBundleDependencies_;
        }

        inline bool CrashOnMergeFail() const {
            return CrashOnMergeFail_;
        }

        inline bool StopOnIncompleteMerge(const bool postmortem) const {
            return !postmortem ? StopOnIncompleteMerge_ : StopAfterIncompleteMerge_;
        }
    };
}
