#include "bundle_meta.h"

#include <util/stream/str.h>
#include <util/string/cast.h>
#include <util/string/split.h>

namespace NFusion {
    const ui32 TBundleVersion::LastGlobalNo = 99999;
    const ui32 TBundleVersion::BetaBoost = 1000;

    TBundleVersion::TBundleVersion(const TString& bundleVersionStr)
        : Disabled(bundleVersionStr == "DISABLED")
        , IsBeta(false)
        , GlobalNo(0)
    {
        ui32 tmp;

        if (!Disabled) {
            TVector<TStringBuf> items = StringSplitter(bundleVersionStr).Split(',');
            if (!items.empty() && TryFromString(items[0], tmp)) {
                GlobalNo = tmp;
                items.erase(items.begin());

                if (std::find(items.begin(), items.end(), "beta") != items.end()) {
                    IsBeta = true;
                }
            }
        }
    }

    TString TBundleVersion::DebugString() const {
        TStringStream ss;
        ss << GetGlobalNo();
        if (IsBeta) {
            ss << ",beta";
        }
        return ss.Str();
    }
}
