#pragma once

#include <util/generic/string.h>

namespace NRtDoc {
    class IBuilderInputs;
}

namespace NFusion {
    namespace NBundleMeta {
        // merge method
        enum class TMode {
            Rebuild,
            WadMerge,
            WadCustomMerge,
            WadPudge,
            Migrate
        };

        // REFRESH-319 option
        enum class TDeploy {
            Gradual,                 // politeness: allow the index to be present only in the new segments (old documents will miss some factors)
            PanicIfMissing,          // the index should exist in all the segments before the merge - or we Panic()
            RebuildOrMerge           // the index is expected to be present in all the segments - if not, the preparate should exist (we will try to rebuild)
            //RebuildAuto            // not implemented yet (accumulate the preparate, and turn the index on when we have data)
        };
    }

    struct TBundleVersion {
        bool Disabled;
        bool IsBeta;
        ui32 GlobalNo;

        static const ui32 LastGlobalNo;

        static const ui32 BetaBoost;

    public:
        TBundleVersion(const TString& bundleVersionStr);

        ui32 GetGlobalNo() const {
            return Min<ui32>(GlobalNo, LastGlobalNo);
        }

        ui32 Beta(ui32 globalNo) const {
            return !IsBeta ? globalNo + BetaBoost : globalNo;
        }

        TString DebugString() const;
    };
}
