#include "bundle_meta.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/folder/path.h>

namespace NFusion {
    Y_UNIT_TEST_SUITE(TExtbuilderBundleVersion) {
        Y_UNIT_TEST(TestBasics) {
            UNIT_ASSERT_VALUES_EQUAL(true, TBundleVersion("DISABLED").Disabled);
            UNIT_ASSERT_VALUES_EQUAL(0, TBundleVersion("DISABLED").GetGlobalNo());
            UNIT_ASSERT_VALUES_EQUAL(false, TBundleVersion("").Disabled);
            UNIT_ASSERT_VALUES_EQUAL(0, TBundleVersion("").GetGlobalNo());
            UNIT_ASSERT_VALUES_EQUAL(false, TBundleVersion("1").Disabled);
            UNIT_ASSERT_VALUES_EQUAL(1234, TBundleVersion("01234").GetGlobalNo());

            // extra parsing
            UNIT_ASSERT_VALUES_EQUAL("0", TBundleVersion("0").DebugString());
            UNIT_ASSERT_VALUES_EQUAL("10", TBundleVersion("10").DebugString());
            UNIT_ASSERT_VALUES_EQUAL("10", TBundleVersion("10,,,,").DebugString());
            UNIT_ASSERT_VALUES_EQUAL("10,beta", TBundleVersion("10,beta").DebugString());
        }

        Y_UNIT_TEST(TestSugar) {
            TBundleVersion bv("5000");
            UNIT_ASSERT_VALUES_EQUAL(1001, bv.Beta(1));
            UNIT_ASSERT_VALUES_EQUAL(101000, bv.Beta(100000));
            UNIT_ASSERT_VALUES_EQUAL(5000, bv.GetGlobalNo());

            TBundleVersion bbv("5000,beta");
            UNIT_ASSERT_VALUES_EQUAL(1, bbv.Beta(1));
            UNIT_ASSERT_VALUES_EQUAL(100000, bbv.Beta(100000));
            UNIT_ASSERT_VALUES_EQUAL(5000, bbv.GetGlobalNo());
        }
    }
}
