#pragma once

#include "wad_decoded_merge.h"
#include "bundle_model.h"

#include <robot/jupiter/library/rtdoc/merger/reg_erf.h>
#include <ysite/yandex/erf_format/erf_format.h>

namespace NFusion {
    template <typename TMerger>
    class TCustomMerger: public ICmdExtensions {
    public:
        virtual void Init(TJupiterCmd& cmd, const TBundleVersion& /*bundleVer*/) override {
            Y_ENSURE(!cmd.OutputPrefix.empty());
        }

        virtual NRtDoc::IWadMerger::TPtr CreateWadCustomMerger() override {
            return MakeIntrusive<TMerger>();
        }
    };

    using TRegErfMerger = TCustomMerger<NRtDoc::TWadDecodedMerger<NDoom::TRegErfIo, NRtDoc::TKeyAccessor<NDoom::TRegErfIo::TKey>>>;

    class TBuildFromMergedPortions : public ICmdExtensions {
    public:
        virtual bool UsesCustomRebuild() const override {
            return true;
        }
    };
}
