#pragma once

#include <kernel/doom/info/index_info.h>

#include <library/cpp/logger/global/global.h>

#include <robot/jupiter/library/opt/panther.h>
#include <robot/jupiter/tools/shards_prepare/lib/panther_utils/index_options_by_tier.h>

#include <util/folder/path.h>
#include <util/stream/file.h>

namespace NFusion {
    void FakePantherInfo(const TString& indexPath, const TString& shard, const NJupiter::TBuildPantherOpts& pantherOpts) {
        const TFsPath path = indexPath + "panther.info";
        if (!path.Exists()) {
            WARNING_LOG << "FakePantherInfo: indexpanther.info not found in" << path.Parent() << Endl;
            return;
        }

        path.CheckExists();
        NDoom::TIndexInfo info;
        {
            TIFStream in(path);
            info = NDoom::LoadIndexInfo(&in);
        }

        if (info.HasPantherIndexInfo() && info.GetPantherIndexInfo().GetPantherVersion()) {
            WARNING_LOG << "FakePatherInfo: the fix did nothing - not needed anymore?" << Endl;
            return;
        }

        NDoom::TPantherIndexInfo doomOpts = NJupiter::NPrivate::GetPantherIndexInfo(shard, pantherOpts.PantherIndexInfoByTier);
        *info.MutablePantherIndexInfo() = doomOpts;

        {
            TOFStream out(path);
            NDoom::SaveIndexInfo(&out, info);
        }
    }
}
