#pragma once

#include "wad_decoded_merge.h"
#include "wad_merge.h"
#include "wad_merge_host_adapter.h"

#include "bundle_model.h"
#include <robot/jupiter/library/rtdoc/merger/reg_erf.h>
#include <ysite/yandex/erf_format/erf_format.h>

#include <util/generic/typelist.h>

namespace NFusion {
    template <typename TMerger, bool PortionDeltaMode = false, bool DeltaMode = true>
    class TBasicHostMerger: public ICmdExtensions {
    public:
        virtual void Init(TJupiterCmd& cmd, const TBundleVersion& /*bundleVer*/) override {
            Y_ENSURE(!cmd.OutputPrefix.empty());
        }

        virtual NRtDoc::IWadMerger::TPtr CreateWadCustomMerger() override {
            TIntrusivePtr<TMerger> merger = MakeIntrusive<TMerger>();
            merger->MutableMeta()->DeltaMode = DeltaMode || PortionDeltaMode;
            merger->MutableMeta()->PortionDeltaMode = PortionDeltaMode;

            NRtDoc::IWadMerger::TPtr hostMerger = MakeIntrusive<NRtDoc::TWadHostAdapter>(std::move(merger));
            return hostMerger;
        }
    };

    // List of IOs where Delta has final DocIds (PortionDeltaMode=true)
    using TOffroadHostIndexPortionIos = TTypeList<NDoom::TRegHostErfIo>;

    // Casual TWadDecodedMerger instantiation
    template <typename TIo, typename TKeyAccessor=NRtDoc::TKeyAccessor<typename TIo::TKey>>
    using TOffroadHostMerger = TBasicHostMerger<NRtDoc::TWadDecodedMerger<TIo, TKeyAccessor>, TOffroadHostIndexPortionIos::THave<TIo>::value>;

    using TRegHostMerger = TOffroadHostMerger<NDoom::TRegHostErfIo>;
    using THostMerger = TBasicHostMerger<NRtDoc::TWadSortMerger>;
}
