#include "info.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/folder/path.h>

Y_UNIT_TEST_SUITE(BuilderTaskInfo) {
    Y_UNIT_TEST(Dump) {
        NRtDoc::TBuilderTask t;
        auto* inp = t.AddInputs();
        inp->SetSrcDir("index/project/index_000/");
        inp->SetSrcMapping("index/project/merger/index_000/aaa.mapping");

        inp = t.AddInputs();
        inp->SetSrcDir("index/project/index_001/");
        inp->ClearSrcMapping();

        auto* o = t.MutableOutput();
        o->SetTrgDir("index/../index/project/index_002_merge");
        o->SetTempDir("index/project/temp_002");

        t.MutableConfig()->SetForceRebuild(true); // just any field

        TFsPath dumpFile("builder_task.pb.txt");
        NFusion::DumpBuilderTask(t, dumpFile);

        UNIT_ASSERT_EQUAL(true, dumpFile.Exists());

        NRtDoc::TBuilderTask t2;
        NFusion::RestoreBuilderTask(t2, dumpFile, {});

        UNIT_ASSERT_EQUAL(true, t2.HasConfig());
        UNIT_ASSERT_EQUAL(true, t2.GetConfig().GetForceRebuild());
        UNIT_ASSERT_EQUAL(true, t2.HasOutput());
        UNIT_ASSERT_VALUES_EQUAL(2, t2.InputsSize());

        UNIT_ASSERT_VALUES_EQUAL("index/../index/project/index_002_merge", t2.GetOutput().GetTrgDir());
        UNIT_ASSERT_VALUES_EQUAL("index/project/temp_002", t2.GetOutput().GetTempDir());

        const auto& inp0 = t2.GetInputs(0);
        UNIT_ASSERT_VALUES_EQUAL("index/project/index_000/", inp0.GetSrcDir());
        UNIT_ASSERT_VALUES_EQUAL("index/project/merger/index_000/aaa.mapping", inp0.GetSrcMapping());
        const auto& inp1 = t2.GetInputs(1);
        UNIT_ASSERT_VALUES_EQUAL("index/project/index_001/", inp1.GetSrcDir());
        UNIT_ASSERT_VALUES_EQUAL("", inp1.GetSrcMapping());

        dumpFile.DeleteIfExists();
    }
}
