#include "keyinvwad.h"

#include <kernel/doom/adaptors/hit_transforming_index_reader.h>
#include <kernel/doom/adaptors/key_filtering_index_reader.h>
#include <kernel/doom/algorithm/transfer.h>
#include <kernel/doom/standard_models_storage/standard_models_storage.h>
#include <kernel/doom/offroad_wad/offroad_ann_wad_io.h>
#include <kernel/doom/yandex/yandex_io.h>

namespace NFusion {
    void TKeyInvWad::Wrangle(const TString& oldPrefix, const TString& newPrefix) {
        //TODO(yrum): Remove this method (it is temporary)
        using TReader =  NDoom::THitTransformingIndexReader<NDoom::TIdentityHitTransformation,
                NDoom::TKeyFilteringIndexReader<NDoom::TEmptyPrefixExceptTelKeyFilter, NDoom::TYandexIo::TReader>>;
        using TWriterIo = NDoom::TOffroadAnnWadIoSortedMultiKeys;
        using TWriter = typename TWriterIo::TWriter;
        using THitModel = typename TWriterIo::THitModel;
        using TKeyModel = typename TWriterIo::TKeyModel;

        TReader reader(oldPrefix);
        TKeyModel keyModel = NDoom::TStandardIoModelsStorage::Model<TKeyModel>(TWriterIo::DefaultKeyModel);
        THitModel hitModel = NDoom::TStandardIoModelsStorage::Model<THitModel>(TWriterIo::DefaultHitModel);

        TWriter writer(hitModel, keyModel, newPrefix + ".wad");
        for (ui32 stage = 1; stage <= TWriter::Stages; ++stage) {
            reader.Restart();
            TransferIndex(&reader, &writer);
        }
        writer.Finish();
    }
}
