#include "log_impl.h"

#include <util/system/defaults.h>

namespace {
    inline TStringBuf StripFileName(TStringBuf s) {
        //TODO(yrum): refactor - publish & reuse NLoggingImpl::StripFileName
        return s.RNextTok(LOCSLASH_C);
    }
}

TComponentLog::TComponentLog(TAutoPtr<TLogBackend> backend)
    : TLog(backend)
{
}

TComponentLog::TComponentLog(const TStringBuf prefix, ELogPriority logLevel)
    : TLog(THolder(new NLoggingImpl::TComponentLogBackend(prefix, logLevel)))
{
}

TSimpleSharedPtr<TOneLineLogElement> TComponentLogFormatter::StartRecord(TLog& logger, const TLogRecordContext& context, TSimpleSharedPtr<TLogElement> earlier) noexcept {
    Y_ASSERT(!earlier);
    TSimpleSharedPtr<TOneLineLogElement> el(new TOneLineLogElement(&logger, context.Priority));

    (*el) << StripFileName(context.SourceLocation.File) << ":" << context.SourceLocation.Line << " ";
    return el;
}

TStringBuf TComponentLogFormatter::RemoveFormatting(const TStringBuf logMessages) noexcept {
    return logMessages.After(':').After(' ');
}
