#include "mercury_l2_fix.h"

namespace NFusion {

    void FixMercuryL2(NYT::IIOClient& client, bool heavyDataLumpsEnabled) {
        //
        // We need to create an empty table for calculated_attrs_l2_global_lumps and content_attrs_l2_global_lumps
        // (so the reader is empty, and not nDoc x TBlob() )
        //
        const NJupiter::TShardsPrepareTables tables = NJupiter::TShardsPrepareTables::Clientless();
        CreateEmptyPortion(client, tables.GetCalculatedAttrsL2GlobalLumpsTable(0));
        if (heavyDataLumpsEnabled) {
            CreateEmptyPortion(client, tables.GetContentAttrsL2GlobalLumpsTable(0));
        }
    }
}
