#pragma once

#include <robot/jupiter/library/tables/shards_prepare.h>
#include <mapreduce/yt/interface/io.h>

namespace NFusion {
    namespace {
        template <typename TTable>
        void CreateEmptyPortion(NYT::IIOClient& client, const TTable& globalLumpTable) {
            const NYT::TRichYPath path = NJupiter::GetYtPathName(globalLumpTable);
            auto ytWriter = client.CreateTableWriter<NPlutonium::TGlobalWadLump>(path);
            ytWriter.Drop(); // creates an empty portion
        }
    }

    void FixMercuryL2(NYT::IIOClient& client, bool heavyDataLumpsEnabled);

}
