#pragma once

#include <robot/jupiter/library/rtdoc/file/model/data_formats.h>
#include <robot/library/plutonium/protos/doc_wad_lumps.pb.h>

using namespace NYT;

namespace NFusion {
    class TPlutoniumDocId final: public NRtDoc::IYtReaderRowPreprocessor {
    public:
        virtual void ProcessRow(google::protobuf::Message* msg, ui32 docId) const override {
            Y_ASSERT(msg && msg->GetDescriptor() == NPlutonium::TDocWadLumps::descriptor());
            static_cast<NPlutonium::TDocWadLumps&>(*msg).SetDocId(docId);
        }

        virtual const google::protobuf::Descriptor* GetRowType() const override {
            return NPlutonium::TDocWadLumps::descriptor();
        }

        virtual THolder<google::protobuf::Message> CreateEmptyObject() const override {
            return MakeHolder<NPlutonium::TDocWadLumps>();
        }

        virtual ui32 GetDocId(const google::protobuf::Message& msg) const override {
            return static_cast<const NPlutonium::TDocWadLumps&>(msg).GetDocId();
        }
    };
}
