#include "timer_wrapper.h"

#include <saas/util/logging/tskv_log.h>
#include <util/system/env.h>

TTimerLog::TTimerLog(TString path, const TString& realm, const TString& mergerTask)
    : TLog(CreateLogBackend(path, TLOG_INFO))
    , Realm(realm)
    , MergerTask(mergerTask)
{    
}

TTimerLog::TTimerLog(THolder<TLogBackend> backend, const TString& realm, const TString& mergerTask)
    : TLog(std::move(backend))
    , Realm(realm)
    , MergerTask(mergerTask)
{
}

TTimerWrapper::TTimerWrapper(TTimerLog& log, TString stage) 
    : Timer(TSimpleTimer())
    , Log(log)
    , Stage(stage)
    , Realm(log.Realm)
    , MergerTask(log.MergerTask)
{
}

TTimerWrapper::~TTimerWrapper() {
    NUtil::TTSKVRecord l("saas-extbuilder-log");
    l.AddIsoEventTime();
    l.ForceAdd("stage", Stage);
    l.ForceAdd("timer", Timer.Get().SecondsFloat());
    l.ForceAdd("realm", Realm);
    l.ForceAdd("service", GetEnv("NANNY_SERVICE_ID"));
    l.ForceAdd("merger_task", MergerTask);
    Log << l.ToString() << Endl;
}
