
#include "tools.h"

#include <robot/jupiter/protos/shards.pb.h>
#include <robot/jupiter/library/tables/shards_prepare.h>

namespace NFusion {
    TString TJupiterHelper::WriteUrlToShardStats(NYT::IIOClient& client, const TString& shard, ui64 docCount) {
        using namespace NJupiter;
        const TShardsPrepareTables& tables = TShardsPrepareTables::Clientless();
        const TTable<TUrlToShardStats> table = tables.GetStatsTableLink();
        auto writer = client.CreateTableWriter<TUrlToShardStats>(table.GetPath());

        TUrlToShardStats stats;
        stats.SetShard(shard);
        stats.SetDocCount(docCount);
        stats.SetDocSize(docCount * (1 << 18)); // we do not really need this
        writer->AddRow(stats, 0);
        return NJupiter::GetYtPathName(table);
    }
}
