#pragma once

#include "bundle_model.h"

#include <robot/jupiter/library/rtdoc/merger/wad_patcher.h>
#include <robot/jupiter/library/rtdoc/file/model/docidmap.h>
#include <kernel/doom/wad/mega_wad.h>
#include <kernel/doom/wad/mega_wad_writer.h>
#include <util/generic/ptr.h>

namespace NRtDoc {
    using namespace NDoom;

    class TWadMerger : public IWadMerger {
    public:
        TWadMerger();

        TWadMerger(const TString& fileName, const TString& mappingFileName);

        ~TWadMerger();

        virtual void Init(const TString& fileName) override;

        //! Add wad to the list of inputs. You must use std::move(wad) here.
        virtual void Add(const TString& wadPath, THolder<TDocIdMap> docIdMap, IWadPatcher::TPtr wadPatcher, const TString& name, bool /*isDelta*/) override;

        //! checks whether the segments all have the same GlobalLumps
        virtual void CheckMergeable() override;

        //! Process all IWads and write merged WAD.
        virtual void Finish() override;

    public:
        virtual bool Empty() const override {
            return Chunks_.empty();
        }

    protected:
        /* if true it's nessesary to sort by id before merge */
        virtual bool IsSortNeeded() const {
            return false;
        }

    private:
        struct TChunk;
        struct TCheckContext;
        TVector<TChunk> Chunks_;
        TString FileName;
        TString MappingFileName;
        THolder<TCheckContext> CheckCtx_;
    };

    class TWadSortMerger : public TWadMerger {
    protected:
        bool IsSortNeeded() const override {
            return true;
        }
    };

}
